<?php
    require_once 'libs/SecureDB.php';
 
    require_once 'libs/SecureRoute.php';

    $router = new SecureRoute([], '/_working/secure-db'); // ✅ BASE PATH SET

    $router->map('GET', '/', function () {

        echo '<h1 style="text-align: center;padding: 25px;">Welcome to Secure DB homepage! </h1>';
    });

    //--insert > single row > start
    $router->map('GET', '/insert', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);

        $id = uniqid();

        $id = $db->insert('users', [
            'name' => "Demo User -  O'Reilly". $id,
            'email' => $id. '@gmail.com',
            'password'=> hash('sha512',   $id),
        ]);
        echo "Inserted ID: $id";

    });    
    //--insert > single row > end


    //--insert > multiple rows > start
    $router->map('GET', '/multi', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);
 

        $rows = [
            ['name' => 'Bob-'.uniqid(), 'email' => 'bob-'.uniqid().'@example.com', 'password'=> hash('sha512',   uniqid())],
            ['name' => 'Mark-'.uniqid(), 'email' => 'mark-'.uniqid().'@example.com', 'password'=> hash('sha512',  uniqid())],
            ['name' => 'Carol-'.uniqid(), 'email' => 'carol-'.uniqid().'@example.com', 'password'=> hash('sha512',   uniqid())],
            ['name' => 'Mike-'.uniqid(), 'email' => 'mike-'.uniqid().'@example.com', 'password'=> hash('sha512',  uniqid())],
        ];

        $db->insertMultiple('users', $rows); // Auto-batched and transactional

        $users = $db->select("SELECT * FROM users ");
        
        echo "<pre>";
        print_r($users);
        echo "</pre>";
        
    });    
    //--insert > multiple rows > end

 

    //--select > start
    $router->map('GET', '/select', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);

        $users = $db->select("SELECT * FROM users WHERE id = :id", ['id' => 3 ]);
        
        echo "<pre>";
        print_r($users);
        echo "</pre>";

    });    
    //--select > end

 
    //--update > start
    $router->map('GET', '/update', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);

        $db->update('users', ['name' => 'New name'], ['id' => 2]);
        
        $users = $db->select("SELECT * FROM users WHERE id = :id", ['id' => 2 ]);
        
        echo "<pre>";
        print_r($users);
        echo "</pre>";

    }); 
    //--update > end 


    //--delete > start
    $router->map('GET', '/delete', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);

        $db->delete('users', ['id' => 2]);
        
        echo "delete";
        
    }); 
    //--delete > end 



    //--escape > start
    $router->map('GET', '/escape', function () {
        
        $db = SecureDB::getInstance([
            'host' => 'localhost',
            'user' => 'root',
            'pass' => '',
            'database' => 'test_db'
        ]);

        $safe = $db->escape("O'Reilly");
        
        echo $safe . "<br><br>";

        $safe = $db->escape("login.php?username=admin' -- &password=anything");
        
        echo $safe . "<br><br>";

        $safe = $db->escape("SELECT * FROM members; DROP members-");
        
        echo $safe . "<br><br>";
        
        
        $safe = $db->escape("http://example.com/vuln.php?code=phpinfo()");
        echo $safe . "<br>";
        
    }); 
    //--escape > end 


    //quick dispatch
    $router->dispatch();


?>