$(document).ready(function () {
     
    const router = new Router('/run-framework/01-static/'); // Update base path as needed 
    
    router.addRoute('', () => {
      var s1 = `
        <header>
          <h1>Welcome to Run Framework</h1>
          <p><strong>Build Fast. Scale Smarter. Run Everywhere.</strong></p>
        </header>

        <section>
          <p>Run Framework is your go-to foundation for building modern, high-performance applications. Whether you're crafting
            a sleek web platform, launching a mobile app, or deploying cloud-native microservices, Run Framework provides the
            speed, flexibility, and power to get your ideas off the ground.</p>
        </section> 
      `;

      $('#app').html(`${s1}`);
    });

    router.addRoute('about', () => {

      var s1 = `         
        <section>
          <h2>Why Run Framework?</h2>
          <ul>
            <li><strong>🚀 Lightning-Fast Performance</strong><br>Optimized for speed from the ground up. Spend less time
              debugging and more time innovating.</li>
            <li><strong>🛠️ Modular & Extensible</strong><br>Customize everything. Plug in what you need, leave out what you
              don’t.</li>
            <li><strong>☁️ Cloud-Ready</strong><br>Built to scale across cloud environments with ease. Deploy once—run anywhere.
            </li>
            <li><strong>🔒 Secure by Design</strong><br>Security best practices baked in from day one.</li>
          </ul>
        </section>
      `;
      $('#app').html(`${s1}`);
    });

    router.addRoute('user/:id', (params) => {

      var s1 = `         
        <div class="container mt-5">
          <h2 class="mb-4">Contact Us</h2>
          <form action="#" method="post">
            <div class="mb-3">
              <label for="name" class="form-label">Name</label>
              <input type="text" class="form-control" id="name" name="name" required>
            </div>

            <div class="mb-3">
              <label for="email" class="form-label">Email address</label>
              <input type="email" class="form-control" id="email" name="email" required>
            </div>

            <div class="mb-3">
              <label for="subject" class="form-label">Subject</label>
              <input type="text" class="form-control" id="subject" name="subject" required>
            </div>

            <div class="mb-3">
              <label for="message" class="form-label">Message</label>
              <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Send Message</button>
          </form>
        </div>
      `;
      $('#app').html(`${s1}`); 
    }); 
    

    router.setDefault((path) => {      
      $('#app').html(`<h2>404 Not Found</h2><p>No route for: ${path}</p>`);
    });

    router.start();

    //get the current route path
    var r1 = router.curpath();
    console.log( r1);
    

    function make_btn_active(el){
      $(document).find('.btn').each(function(i1, v1){      
        var btn_name = $(this).attr('btn_type');   
        el === btn_name ?  $(this).addClass('btn-success') :  $(this).removeClass('btn-success');         
      });
    };


    // Navigation handlers
    $('#nav-home').click(e => {
      e.preventDefault();
      make_btn_active("home"); 
      router.navigate('');
    });

    $('#nav-about').click(e => {
      e.preventDefault();
      make_btn_active("about"); 
      router.navigate('about');
    });

    $('#nav-contact').click(e => {
      e.preventDefault();
      make_btn_active("contact"); 
      router.navigate('user/contact');
    }); 

  });